/*1:*/
#line 30 "integer_matrix.w"

#include "integer_matrix.h"
#include <math.h>
#include <LEDA/array.h>
/*2:*/
#line 44 "integer_matrix.w"






void integer_matrix::flip_rows(int i,int j)
{integer_vector*p= v[i];
v[i]= v[j];
v[j]= p;
}


integer_matrix::integer_matrix(int dim1,int dim2)
{
if(dim1<0||dim2<0)
error_handler(1,"matrix: negative dimension.");

d1= dim1;
d2= dim2;

if(d1>0)
{v= new integer_vector*[d1];
for(int i= 0;i<d1;i++)v[i]= new integer_vector(d2);
}
else v= nil;
}


integer_matrix::integer_matrix(const integer_matrix&p)
{
d1= p.d1;
d2= p.d2;

if(d1>0)
{v= new integer_vector*[d1];
for(int i= 0;i<d1;i++)v[i]= new integer_vector(*p.v[i]);
}
else v= nil;
}

integer_matrix::integer_matrix(const array<integer_vector>&A)
{int low= A.low();int high= A.high();
d2= high-low+1;
d1= A[low].dim();


if(d1>0)
{v= new integer_vector*[d1];
for(int i= 0;i<d1;i++)
{v[i]= new integer_vector(d2);
for(int j= 0;j<d2;j++)v[i]->v[j]= A[low+j][i];
}
}
else v= nil;
}

integer_matrix::integer_matrix(int dim1,int dim2,number**p)
{d1= dim1;
d2= dim2;
v= new integer_vector*[d1];
for(int i= 0;i<d1;i++)
{v[i]= new integer_vector(d2);
for(int j= 0;j<d2;j++)elem(i,j)= p[i][j];
}

}

integer_matrix::~integer_matrix()
{if(v)
{while(d1--)delete v[d1];
delete v;
}
}


void integer_matrix::check_dimensions(const integer_matrix&mat)const
{if(d1!=mat.d1||d2!=mat.d2)
error_handler(1,"incompatible matrix types.");
}

integer_matrix::integer_matrix(const integer_vector&vec)
{d1= vec.d;
d2= 1;
v= new integer_vector*[d1];
for(int i= 0;i<d1;i++)
{v[i]= new integer_vector(1);
elem(i,0)= vec[i];
}

}



integer_matrix&integer_matrix::operator= (const integer_matrix&mat)
{register int i,j;

if(d1!=mat.d1||d2!=mat.d2)
{for(i= 0;i<d1;i++)delete v[i];
delete v;
d1= mat.d1;
d2= mat.d2;
v= new integer_vector*[d1];
for(i= 0;i<d1;i++)v[i]= new integer_vector(d2);
}

for(i= 0;i<d1;i++)
for(j= 0;j<d2;j++)elem(i,j)= mat.elem(i,j);

return*this;
}

int integer_matrix::operator==(const integer_matrix&x)const
{register int i,j;
if(d1!=x.d1||d2!=x.d2)return false;

for(i= 0;i<d1;i++)
for(j= 0;j<d2;j++)
if(elem(i,j)!=x.elem(i,j))return false;

return true;
}

integer_vector integer_matrix::col(int i)const
{if(i<0||i>=d2)error_handler(1,"matrix: col index out of range");
integer_vector result(d1);
int j= d1;
while(j--)result.v[j]= elem(j,i);
return result;
}

integer_matrix::operator integer_vector()const
{if(d2!=1)
error_handler(1,"error: cannot make integer_vector from matrix\n");
return col(0);
}

integer_matrix integer_matrix::operator+(const integer_matrix&mat)
{register int i,j;
check_dimensions(mat);
integer_matrix result(d1,d2);
for(i= 0;i<d1;i++)
for(j= 0;j<d2;j++)
result.elem(i,j)= elem(i,j)+mat.elem(i,j);
return result;
}

integer_matrix&integer_matrix::operator+= (const integer_matrix&mat)
{register int i,j;
check_dimensions(mat);
for(i= 0;i<d1;i++)
for(j= 0;j<d2;j++)
elem(i,j)+= mat.elem(i,j);
return*this;
}

integer_matrix&integer_matrix::operator-= (const integer_matrix&mat)
{register int i,j;
check_dimensions(mat);
for(i= 0;i<d1;i++)
for(j= 0;j<d2;j++)
elem(i,j)-= mat.elem(i,j);
return*this;
}


integer_matrix integer_matrix::operator-(const integer_matrix&mat)
{register int i,j;
check_dimensions(mat);
integer_matrix result(d1,d2);
for(i= 0;i<d1;i++)
for(j= 0;j<d2;j++)
result.elem(i,j)= elem(i,j)-mat.elem(i,j);
return result;
}


integer_matrix integer_matrix::operator-()
{register int i,j;
integer_matrix result(d1,d2);
for(i= 0;i<d1;i++)
for(j= 0;j<d2;j++)
result.elem(i,j)= -elem(i,j);
return result;
}


integer_matrix integer_matrix::operator*(number f)const
{register int i,j;
integer_matrix result(d1,d2);
for(i= 0;i<d1;i++)
for(j= 0;j<d2;j++)
result.elem(i,j)= elem(i,j)*f;
return result;
}

integer_matrix integer_matrix::operator*(const integer_matrix&mat)const
{if(d2!=mat.d1)
error_handler(1,"matrix multiplication: incompatible matrix types\n");

integer_matrix result(d1,mat.d2);
register int i,j;

for(i= 0;i<mat.d2;i++)
for(j= 0;j<d1;j++)result.elem(j,i)= *v[j]*mat.col(i);

return result;

}




ostream&operator<<(ostream&s,const integer_matrix&M)
{int i;
s<<"\n";
for(i= 0;i<M.d1;i++)s<<M[i]<<"\n";
return s;
}

istream&operator>>(istream&s,integer_matrix&M)
{int i= 0;
while(i<M.d1&&s>>M[i++]);
return s;
}


integer_matrix identity(int n)
{integer_matrix result(n,n);

for(int i= 0;i<n;i++)
for(int j= 0;j<n;j++)
result(i,j)= (i==j?1:0);
return result;
}




integer_matrix trans(const integer_matrix&M)
{int d1= M.dim1();
int d2= M.dim2();
integer_matrix result(d2,d1);
for(int i= 0;i<d2;i++)
for(int j= 0;j<d1;j++)
result.elem(i,j)= M(j,i);
return result;
}



/*:2*/
#line 34 "integer_matrix.w"
;
/*3:*/
#line 300 "integer_matrix.w"




template<class T>
void swap(T&x,T&y)
{T h= x;x= y;y= h;
}



/*:3*//*4:*/
#line 328 "integer_matrix.w"


bool linear_solver(const integer_matrix&A,const integer_vector&b,
integer_vector&x,number&D,integer_matrix&spanning_vectors,integer_vector&c)
{

/*5:*/
#line 352 "integer_matrix.w"


int i,j,k;


int rows= A.dim1();
int cols= A.dim2();


if(b.dim()!=rows)error_handler(1,"linear_solver: b has wrong dimension");


integer_matrix C(rows,cols+1);



for(i= 0;i<rows;i++){
for(j= 0;j<cols;j++)
{C(i,j)= A(i,j);
}
C(i,cols)= b[i];
}

integer_matrix L(rows,rows);

for(i= 0;i<rows;i++)
for(j= 0;j<rows;j++)L(i,j)= (i==j?1:0);



/*:5*/
#line 334 "integer_matrix.w"


/*6:*/
#line 384 "integer_matrix.w"



array<int>var(0,cols-1);

for(j= 0;j<cols;j++)
var[j]= j;



number denom= 1;

int sign= 1;

int rank= 0;


for(k= 0;k<rows;k++){

/*7:*/
#line 423 "integer_matrix.w"


bool non_zero_found= false;

for(i= k;i<rows;i++){

for(j= k;j<cols&&C(i,j)==0;j++);


if(j<cols){non_zero_found= true;break;}


}



/*:7*/
#line 403 "integer_matrix.w"


if(non_zero_found){

rank++;

/*8:*/
#line 442 "integer_matrix.w"



if(i!=k){

sign= -sign;





swap(L[i],L[k]);
swap(C[i],C[k]);

}



if(j!=k){

sign= -sign;



for(int ih= 0;ih<rows;ih++)swap(C(ih,k),C(ih,j));






swap(var[k],var[j]);
}

/*:8*/
#line 409 "integer_matrix.w"


/*9:*/
#line 480 "integer_matrix.w"


for(i= k+1;i<rows;i++){
for(j= 0;j<rows;j++)
{L(i,j)= (L(i,j)*C(k,k)-C(i,k)*L(k,j))/denom;

}
}


for(i= k+1;i<rows;i++)
{


number temp= C(i,k);

for(j= k;j<=cols;j++)
{
C(i,j)= (C(i,j)*C(k,k)-temp*C(k,j))/denom;

}


}


denom= C(k,k);



/*10:*/
#line 517 "integer_matrix.w"


#ifdef TESTALL

for(i= 0;i<rows;i++)
{
for(j= 0;j<cols;j++)
{
number Sum= 0;
for(int l= 0;l<rows;l++)Sum+= L(i,l)*A(l,var[j]);

if(Sum!=C(i,j))
error_handler(1,"L*A*V different from C");


}
}
#endif




/*:10*/
#line 510 "integer_matrix.w"


/*:9*/
#line 411 "integer_matrix.w"


}

else{break;}

}



/*:6*/
#line 336 "integer_matrix.w"



/*11:*/
#line 546 "integer_matrix.w"



bool solvable= true;

for(i= rank;i<rows&&C(i,cols)==0;i++);

if(i<rows)
{solvable= false;
c= integer_vector(rows);

for(j= 0;j<rows;j++)c[j]= L(i,j);
}



/*:11*/
#line 339 "integer_matrix.w"


if(solvable){/*12:*/
#line 588 "integer_matrix.w"



x= integer_vector(cols);
D= denom;

for(i= rank-1;i>=0;i--)
{number h= C(i,cols)*D;
for(j= i+1;j<rank;j++)h-= C(i,j)*x[var[j]];
x[var[i]]= h/C(i,i);
}

#ifdef TEST

{for(i= 0;i<rows;i++)
{number sum= 0;
for(j= 0;j<cols;j++)sum+= A(i,j)*x[j];
if(sum!=D*b[i])
error_handler(1,"linalg: base is not a solution");
}
}
#endif


int dimension= cols-rank;

spanning_vectors= integer_matrix(cols,dimension);

if(dimension>0){











for(int l= 0;l<dimension;l++){

spanning_vectors(var[rank+l],l)= D;

for(i= rank-1;i>=0;i--)
{

number h= -C(i,rank+l)*D;
for(j= i+1;j<rank;j++)h-= C(i,j)*spanning_vectors(var[j],l);

spanning_vectors(var[i],l)= h/C(i,i);


}



#ifdef TEST



{integer_vector zero(rows);
if(A*spanning_vectors.col(l)!=zero)
error_handler(1,"linalg: spanning_vector is not a solution");
}

#endif
}

}


/*:12*/
#line 341 "integer_matrix.w"

}




return solvable;
}

/*:4*//*13:*/
#line 668 "integer_matrix.w"



number determinant(const integer_matrix&A)
{
if(A.dim1()!=A.dim2())
error_handler(1,"determinant: only square matrices are legal inputs");
integer_vector b(A.dim1());
/*5:*/
#line 352 "integer_matrix.w"


int i,j,k;


int rows= A.dim1();
int cols= A.dim2();


if(b.dim()!=rows)error_handler(1,"linear_solver: b has wrong dimension");


integer_matrix C(rows,cols+1);



for(i= 0;i<rows;i++){
for(j= 0;j<cols;j++)
{C(i,j)= A(i,j);
}
C(i,cols)= b[i];
}

integer_matrix L(rows,rows);

for(i= 0;i<rows;i++)
for(j= 0;j<rows;j++)L(i,j)= (i==j?1:0);



/*:5*/
#line 676 "integer_matrix.w"

/*6:*/
#line 384 "integer_matrix.w"



array<int>var(0,cols-1);

for(j= 0;j<cols;j++)
var[j]= j;



number denom= 1;

int sign= 1;

int rank= 0;


for(k= 0;k<rows;k++){

/*7:*/
#line 423 "integer_matrix.w"


bool non_zero_found= false;

for(i= k;i<rows;i++){

for(j= k;j<cols&&C(i,j)==0;j++);


if(j<cols){non_zero_found= true;break;}


}



/*:7*/
#line 403 "integer_matrix.w"


if(non_zero_found){

rank++;

/*8:*/
#line 442 "integer_matrix.w"



if(i!=k){

sign= -sign;





swap(L[i],L[k]);
swap(C[i],C[k]);

}



if(j!=k){

sign= -sign;



for(int ih= 0;ih<rows;ih++)swap(C(ih,k),C(ih,j));






swap(var[k],var[j]);
}

/*:8*/
#line 409 "integer_matrix.w"


/*9:*/
#line 480 "integer_matrix.w"


for(i= k+1;i<rows;i++){
for(j= 0;j<rows;j++)
{L(i,j)= (L(i,j)*C(k,k)-C(i,k)*L(k,j))/denom;

}
}


for(i= k+1;i<rows;i++)
{


number temp= C(i,k);

for(j= k;j<=cols;j++)
{
C(i,j)= (C(i,j)*C(k,k)-temp*C(k,j))/denom;

}


}


denom= C(k,k);



/*10:*/
#line 517 "integer_matrix.w"


#ifdef TESTALL

for(i= 0;i<rows;i++)
{
for(j= 0;j<cols;j++)
{
number Sum= 0;
for(int l= 0;l<rows;l++)Sum+= L(i,l)*A(l,var[j]);

if(Sum!=C(i,j))
error_handler(1,"L*A*V different from C");


}
}
#endif




/*:10*/
#line 510 "integer_matrix.w"


/*:9*/
#line 411 "integer_matrix.w"


}

else{break;}

}



/*:6*/
#line 677 "integer_matrix.w"


if(rank<rows)return 0;
else
return sign*denom;

}

/*:13*//*14:*/
#line 707 "integer_matrix.w"




number determinant(const integer_matrix&A,
integer_matrix&LD,integer_matrix&UD,array<int>&q,integer_vector&c)
{
if(A.dim1()!=A.dim2())
error_handler(1,"determinant: only square matrices are legal inputs");
integer_vector b(A.dim1());
/*5:*/
#line 352 "integer_matrix.w"


int i,j,k;


int rows= A.dim1();
int cols= A.dim2();


if(b.dim()!=rows)error_handler(1,"linear_solver: b has wrong dimension");


integer_matrix C(rows,cols+1);



for(i= 0;i<rows;i++){
for(j= 0;j<cols;j++)
{C(i,j)= A(i,j);
}
C(i,cols)= b[i];
}

integer_matrix L(rows,rows);

for(i= 0;i<rows;i++)
for(j= 0;j<rows;j++)L(i,j)= (i==j?1:0);



/*:5*/
#line 717 "integer_matrix.w"

/*6:*/
#line 384 "integer_matrix.w"



array<int>var(0,cols-1);

for(j= 0;j<cols;j++)
var[j]= j;



number denom= 1;

int sign= 1;

int rank= 0;


for(k= 0;k<rows;k++){

/*7:*/
#line 423 "integer_matrix.w"


bool non_zero_found= false;

for(i= k;i<rows;i++){

for(j= k;j<cols&&C(i,j)==0;j++);


if(j<cols){non_zero_found= true;break;}


}



/*:7*/
#line 403 "integer_matrix.w"


if(non_zero_found){

rank++;

/*8:*/
#line 442 "integer_matrix.w"



if(i!=k){

sign= -sign;





swap(L[i],L[k]);
swap(C[i],C[k]);

}



if(j!=k){

sign= -sign;



for(int ih= 0;ih<rows;ih++)swap(C(ih,k),C(ih,j));






swap(var[k],var[j]);
}

/*:8*/
#line 409 "integer_matrix.w"


/*9:*/
#line 480 "integer_matrix.w"


for(i= k+1;i<rows;i++){
for(j= 0;j<rows;j++)
{L(i,j)= (L(i,j)*C(k,k)-C(i,k)*L(k,j))/denom;

}
}


for(i= k+1;i<rows;i++)
{


number temp= C(i,k);

for(j= k;j<=cols;j++)
{
C(i,j)= (C(i,j)*C(k,k)-temp*C(k,j))/denom;

}


}


denom= C(k,k);



/*10:*/
#line 517 "integer_matrix.w"


#ifdef TESTALL

for(i= 0;i<rows;i++)
{
for(j= 0;j<cols;j++)
{
number Sum= 0;
for(int l= 0;l<rows;l++)Sum+= L(i,l)*A(l,var[j]);

if(Sum!=C(i,j))
error_handler(1,"L*A*V different from C");


}
}
#endif




/*:10*/
#line 510 "integer_matrix.w"


/*:9*/
#line 411 "integer_matrix.w"


}

else{break;}

}



/*:6*/
#line 718 "integer_matrix.w"


if(rank<rows)
{c= L.row(rows-1);
return 0;
}
else
{LD= L;
UD= integer_matrix(rows,rows);
for(i= 0;i<rows;i++)
for(j= 0;j<rows;j++)UD(i,j)= C(i,j);
q= var;
return sign*denom;
}

}

bool verify_determinant(const integer_matrix&A,
number D,
integer_matrix&L,integer_matrix&U,array<int>q,
integer_vector&c)
{int n= A.dim1();
int i,j;
if(D==0)
{
integer_vector zero(n);
return(trans(A)*c==zero);
}
else
{
if(L(0,0)!=1)return false;
for(i= 0;i<n;i++)
{for(j= 0;j<i;j++)if(U(i,j)!=0)return false;

if(i>0&&L(i,i)!=U(i-1,i-1))return false;

for(j= i+1;j<n;j++)if(L(i,j)!=0)return false;
}

integer_matrix LA= L*A;
for(j= 0;j<n;j++)
if(LA.col(q[j])!=U.col(j))return false;

int sign= 1;


array<bool>already_considered(0,n-1);


for(i= 0;i<n;i++)already_considered[i]= false;

for(i= 0;i<n;i++)already_considered[q[i]]= true;

for(i= 0;i<n;i++)
if(!already_considered[i])
error_handler(1,"q is not a permutation");
else
already_considered[i]= false;


for(i= 0;i<n;i++)
{if(already_considered[i])continue;



int k= q[i];
already_considered[i]= true;

while(k!=i)
{sign= -sign;
already_considered[k]= true;
k= q[k];
}

}


return(D==sign*U(n-1,n-1));




}
}

/*:14*//*15:*/
#line 808 "integer_matrix.w"


int rank(const integer_matrix&A)
{
if(A.dim1()!=A.dim2())
error_handler(1,"rank: only square matrices are legal inputs");
integer_vector b(A.dim1());
/*5:*/
#line 352 "integer_matrix.w"


int i,j,k;


int rows= A.dim1();
int cols= A.dim2();


if(b.dim()!=rows)error_handler(1,"linear_solver: b has wrong dimension");


integer_matrix C(rows,cols+1);



for(i= 0;i<rows;i++){
for(j= 0;j<cols;j++)
{C(i,j)= A(i,j);
}
C(i,cols)= b[i];
}

integer_matrix L(rows,rows);

for(i= 0;i<rows;i++)
for(j= 0;j<rows;j++)L(i,j)= (i==j?1:0);



/*:5*/
#line 815 "integer_matrix.w"

/*6:*/
#line 384 "integer_matrix.w"



array<int>var(0,cols-1);

for(j= 0;j<cols;j++)
var[j]= j;



number denom= 1;

int sign= 1;

int rank= 0;


for(k= 0;k<rows;k++){

/*7:*/
#line 423 "integer_matrix.w"


bool non_zero_found= false;

for(i= k;i<rows;i++){

for(j= k;j<cols&&C(i,j)==0;j++);


if(j<cols){non_zero_found= true;break;}


}



/*:7*/
#line 403 "integer_matrix.w"


if(non_zero_found){

rank++;

/*8:*/
#line 442 "integer_matrix.w"



if(i!=k){

sign= -sign;





swap(L[i],L[k]);
swap(C[i],C[k]);

}



if(j!=k){

sign= -sign;



for(int ih= 0;ih<rows;ih++)swap(C(ih,k),C(ih,j));






swap(var[k],var[j]);
}

/*:8*/
#line 409 "integer_matrix.w"


/*9:*/
#line 480 "integer_matrix.w"


for(i= k+1;i<rows;i++){
for(j= 0;j<rows;j++)
{L(i,j)= (L(i,j)*C(k,k)-C(i,k)*L(k,j))/denom;

}
}


for(i= k+1;i<rows;i++)
{


number temp= C(i,k);

for(j= k;j<=cols;j++)
{
C(i,j)= (C(i,j)*C(k,k)-temp*C(k,j))/denom;

}


}


denom= C(k,k);



/*10:*/
#line 517 "integer_matrix.w"


#ifdef TESTALL

for(i= 0;i<rows;i++)
{
for(j= 0;j<cols;j++)
{
number Sum= 0;
for(int l= 0;l<rows;l++)Sum+= L(i,l)*A(l,var[j]);

if(Sum!=C(i,j))
error_handler(1,"L*A*V different from C");


}
}
#endif




/*:10*/
#line 510 "integer_matrix.w"


/*:9*/
#line 411 "integer_matrix.w"


}

else{break;}

}



/*:6*/
#line 816 "integer_matrix.w"

return rank;

}




bool inverse(const integer_matrix&A,
integer_matrix&inverse,number&D,
integer_vector&c)
{
if(A.dim1()!=A.dim2())
error_handler(1,"inverse: only square matrices are legal inputs");
integer_vector b(A.dim1());
/*5:*/
#line 352 "integer_matrix.w"


int i,j,k;


int rows= A.dim1();
int cols= A.dim2();


if(b.dim()!=rows)error_handler(1,"linear_solver: b has wrong dimension");


integer_matrix C(rows,cols+1);



for(i= 0;i<rows;i++){
for(j= 0;j<cols;j++)
{C(i,j)= A(i,j);
}
C(i,cols)= b[i];
}

integer_matrix L(rows,rows);

for(i= 0;i<rows;i++)
for(j= 0;j<rows;j++)L(i,j)= (i==j?1:0);



/*:5*/
#line 831 "integer_matrix.w"

/*6:*/
#line 384 "integer_matrix.w"



array<int>var(0,cols-1);

for(j= 0;j<cols;j++)
var[j]= j;



number denom= 1;

int sign= 1;

int rank= 0;


for(k= 0;k<rows;k++){

/*7:*/
#line 423 "integer_matrix.w"


bool non_zero_found= false;

for(i= k;i<rows;i++){

for(j= k;j<cols&&C(i,j)==0;j++);


if(j<cols){non_zero_found= true;break;}


}



/*:7*/
#line 403 "integer_matrix.w"


if(non_zero_found){

rank++;

/*8:*/
#line 442 "integer_matrix.w"



if(i!=k){

sign= -sign;





swap(L[i],L[k]);
swap(C[i],C[k]);

}



if(j!=k){

sign= -sign;



for(int ih= 0;ih<rows;ih++)swap(C(ih,k),C(ih,j));






swap(var[k],var[j]);
}

/*:8*/
#line 409 "integer_matrix.w"


/*9:*/
#line 480 "integer_matrix.w"


for(i= k+1;i<rows;i++){
for(j= 0;j<rows;j++)
{L(i,j)= (L(i,j)*C(k,k)-C(i,k)*L(k,j))/denom;

}
}


for(i= k+1;i<rows;i++)
{


number temp= C(i,k);

for(j= k;j<=cols;j++)
{
C(i,j)= (C(i,j)*C(k,k)-temp*C(k,j))/denom;

}


}


denom= C(k,k);



/*10:*/
#line 517 "integer_matrix.w"


#ifdef TESTALL

for(i= 0;i<rows;i++)
{
for(j= 0;j<cols;j++)
{
number Sum= 0;
for(int l= 0;l<rows;l++)Sum+= L(i,l)*A(l,var[j]);

if(Sum!=C(i,j))
error_handler(1,"L*A*V different from C");


}
}
#endif




/*:10*/
#line 510 "integer_matrix.w"


/*:9*/
#line 411 "integer_matrix.w"


}

else{break;}

}



/*:6*/
#line 832 "integer_matrix.w"


if(rank<rows)
{


c= integer_vector(rows);

for(j= 0;j<rows;j++)c[j]= L(rows-1,j);


return false;
}

/*16:*/
#line 862 "integer_matrix.w"



inverse= integer_matrix(rows,rows);

for(i= 0;i<rows;i++){

for(j= rows-1;j>=0;j--)

{number h= L(j,i)*D;
for(int l= j+1;l<rows;l++)h-= C(j,l)*inverse(var[l],i);
inverse(var[j],i)= h/C(j,j);
}

}

#ifdef TEST
if(!(A*inverse==identity(rows)*D))
error_handler(1,"matrix inverse computed incorrectly");
#endif




/*:16*/
#line 846 "integer_matrix.w"
;

return true;



}



/*:15*//*17:*/
#line 888 "integer_matrix.w"




bool homogeneous_linear_solver(const integer_matrix&A,
integer_vector&x)


{
integer_vector b(A.dim1());
number D;
/*5:*/
#line 352 "integer_matrix.w"


int i,j,k;


int rows= A.dim1();
int cols= A.dim2();


if(b.dim()!=rows)error_handler(1,"linear_solver: b has wrong dimension");


integer_matrix C(rows,cols+1);



for(i= 0;i<rows;i++){
for(j= 0;j<cols;j++)
{C(i,j)= A(i,j);
}
C(i,cols)= b[i];
}

integer_matrix L(rows,rows);

for(i= 0;i<rows;i++)
for(j= 0;j<rows;j++)L(i,j)= (i==j?1:0);



/*:5*/
#line 899 "integer_matrix.w"

/*6:*/
#line 384 "integer_matrix.w"



array<int>var(0,cols-1);

for(j= 0;j<cols;j++)
var[j]= j;



number denom= 1;

int sign= 1;

int rank= 0;


for(k= 0;k<rows;k++){

/*7:*/
#line 423 "integer_matrix.w"


bool non_zero_found= false;

for(i= k;i<rows;i++){

for(j= k;j<cols&&C(i,j)==0;j++);


if(j<cols){non_zero_found= true;break;}


}



/*:7*/
#line 403 "integer_matrix.w"


if(non_zero_found){

rank++;

/*8:*/
#line 442 "integer_matrix.w"



if(i!=k){

sign= -sign;





swap(L[i],L[k]);
swap(C[i],C[k]);

}



if(j!=k){

sign= -sign;



for(int ih= 0;ih<rows;ih++)swap(C(ih,k),C(ih,j));






swap(var[k],var[j]);
}

/*:8*/
#line 409 "integer_matrix.w"


/*9:*/
#line 480 "integer_matrix.w"


for(i= k+1;i<rows;i++){
for(j= 0;j<rows;j++)
{L(i,j)= (L(i,j)*C(k,k)-C(i,k)*L(k,j))/denom;

}
}


for(i= k+1;i<rows;i++)
{


number temp= C(i,k);

for(j= k;j<=cols;j++)
{
C(i,j)= (C(i,j)*C(k,k)-temp*C(k,j))/denom;

}


}


denom= C(k,k);



/*10:*/
#line 517 "integer_matrix.w"


#ifdef TESTALL

for(i= 0;i<rows;i++)
{
for(j= 0;j<cols;j++)
{
number Sum= 0;
for(int l= 0;l<rows;l++)Sum+= L(i,l)*A(l,var[j]);

if(Sum!=C(i,j))
error_handler(1,"L*A*V different from C");


}
}
#endif




/*:10*/
#line 510 "integer_matrix.w"


/*:9*/
#line 411 "integer_matrix.w"


}

else{break;}

}



/*:6*/
#line 900 "integer_matrix.w"


integer_matrix spanning_vectors;


/*12:*/
#line 588 "integer_matrix.w"



x= integer_vector(cols);
D= denom;

for(i= rank-1;i>=0;i--)
{number h= C(i,cols)*D;
for(j= i+1;j<rank;j++)h-= C(i,j)*x[var[j]];
x[var[i]]= h/C(i,i);
}

#ifdef TEST

{for(i= 0;i<rows;i++)
{number sum= 0;
for(j= 0;j<cols;j++)sum+= A(i,j)*x[j];
if(sum!=D*b[i])
error_handler(1,"linalg: base is not a solution");
}
}
#endif


int dimension= cols-rank;

spanning_vectors= integer_matrix(cols,dimension);

if(dimension>0){











for(int l= 0;l<dimension;l++){

spanning_vectors(var[rank+l],l)= D;

for(i= rank-1;i>=0;i--)
{

number h= -C(i,rank+l)*D;
for(j= i+1;j<rank;j++)h-= C(i,j)*spanning_vectors(var[j],l);

spanning_vectors(var[i],l)= h/C(i,i);


}



#ifdef TEST



{integer_vector zero(rows);
if(A*spanning_vectors.col(l)!=zero)
error_handler(1,"linalg: spanning_vector is not a solution");
}

#endif
}

}


/*:12*/
#line 905 "integer_matrix.w"
;
if(dimension==0)return false;

for(i= 0;i<cols;i++)x[i]= spanning_vectors(i,0);
return true;
}


/*:17*/
#line 35 "integer_matrix.w"
;

/*:1*/
