@* The Demo Program.
\label{main-fkt}
We described how to use the demo programm earlier, but we
repeat it here for convenience.

\howtousesec

We first give a function that tells the user the correct usage of the
command line arguments of the program when he makes a mistake when
invoking the program.

In the command line, the user can give any number of the above arguments, but
only the last ones are valid.


@<Main program@>=

#include "chull.h"
#include <time.h> // we use |time()| and its relatives

void tell_usage(string prg_name)
// |prg_name| is the name of the executable program
{ 
cout << "Usage: " << prg_name<< " [ m | k | f filename | p | n | s | V | M | S]*"<< endl;
        // a regular expression
  exit(1);
}

@ The main program first reads in the command line setting the
options, then it processes the data.
@<Main...@>+=

enum input_method {MOUSE,KEYS,INPUTFILE};

main(int argc, char **argv)
{
  @<Read the command line@>@;
  @<Process the data@>;
}

@ In the command line, every option consists of a single character.
@<Read the c...@>=
  string_istream args(argc,argv); 
        // create an input stream from the command line
  string prg_name; // the name of the compiled, executable program
  args >> prg_name; // get the name from the command line
  string option; // the options we will take from the command line
  string data_file = "/dev/null"; // the name of the file that contains the data; 
  /* |data_file| is initialized to |"/dev/null"| to avoid complicated
     special treatment when no input file is specified */
  int dimension; // the dimension we will work in
  int number_of_points;
   // appears in input files generated by {\tt rbox}, not used by our program
  input_method read_from = MOUSE; // default: read from mouse
  search_method m = SEGMENT_WALK; // default: segment walk
  bool draw_all = true; // draw every insert step (if |dimension == 2|)
  bool suppress = false; // suppress any display (if |dimension==2|)
  bool print_simplices = false;
	     // print information about all simplices after an insert

  while (true) {
    args >> option;
    if (args.eof()) break; // as long as we have command line arguments
    if (option.length() != 1) 
        // if the current argument has more than one character
      tell_usage(prg_name); // tell the correct usage of the program
    switch (option[0]) { // which option is to be processed?
      case 'm':
	read_from = MOUSE;
	break;
      case 'k':
	read_from = KEYS;
	break;
      case 'f':
	/* this argument must be followed by another argument which is
	   taken as the name of a file from which we read the data */
        args>>data_file; // get the filename
        if (args.eof())
	  // print error message if no file is specified
          tell_usage(prg_name); 
        read_from = INPUTFILE; // we read from a file
	break;
      case 'p':
	print_simplices = true;
	break;
      case 'n':
	draw_all = false;
	break;
      case 's':
	suppress=true;
	break;
      case 'V':
	m = VISIBILITY;
	break;
      case 'M':
	m = MODIFIED_VISIBILITY;
	break;
      case 'S':
	m = SEGMENT_WALK;
	break; 
      default:
	tell_usage(prg_name);
	break;
    }
  }
  
@ Here is how we process the data.
@<Process the data@>=
  /* if the input is not taken from the mouse, we need a file from
     which we read the data */  
  file_istream file_in(data_file); // |file_istream| is a {\sl LEDA} type
  if (!file_in) {
    cout << "unable to open file " << data_file << endl;
    exit(2);
  }

  switch(read_from) {
    case MOUSE:
      { @<Input from mouse@>@;
      }
      exit(0);
      break;
    case KEYS:
      cout << "Dimension of coordinate vectors: ";
      cin >> dimension;
      break;
    case INPUTFILE:
      file_in >> dimension;
      file_in >> number_of_points; 
      break;
  }
  @<Input from keyboard or file@>@;


@ 
We use LEDA's |window| type to implement a graphical input tool.
We are working with the X11R5 (xview) window system.

By a click of the left mouse button, we can input a new two
dimensional point into the
whole complex. Then the triangulation will be drawn onto the screen.
The convex hull is represented by thick lines, whereas the other lines
of the triangulation are drawn as thin lines.
With a click of the middle mouse button the point next to the mouse pointer
is deleted. The triangulation will be updated immediately. A click of the right
mouse button ends the program.
The input points are automatically logged to the file {\tt chull.pts}.

@<Input from mouse@>=
window W;
W.clear();
Triangulation T(2, m); // we are working in the plane with search method |m|
array<integer> L(0,2); // for creation of x
double a,b;
file_ostream protocol("chull.pts");
int mouse=0; // variable to indicate which mouse button was pressed
L[0]=100;
time_t now = time(nil); // What's the time, please?
protocol << "Chull protocol from " << ctime(&now) << endl;// write heading
do {
  mouse=W.read_mouse(a,b);
          // read the |window| coordinates into |a| and |b|
  L[1]=a*100;
  L[2]=b*100;
  d_rat_point x(L,homogeneous);
  if(mouse==1) { // left button pressed
    protocol << "insert " << x << endl;
    T.insert(x);
  }
  if (mouse==2) {  // middle button pressed
    x=T.find_closest_point(x);
    protocol << "delete " << x << endl;
    T.del(x);
  }
  W.clear();
  T.show(W);
  if (print_simplices) T.print_all();
  }
while(mouse!=3) ; // while mouse click is not the right button
cout << endl << "Searched Simplices: " << T.searched_simplices << endl;
cout << "Simplices created: " << T.created_simplices() << endl;
        // only for statistical reasons


@
If we take the input from the keyboard or from a file, we read
for each point its |dimension| coordinates and insert it.
If |dimension == 2| we also open a graphics window in order to
display the triangulation. The window remains on the
screen until the right mouse button is pressed in it.
Keyboard input is terminated by an end-of-file ({\tt ctrl-D}).
After the the input is read in, the triangulation is cut down piece by
piece by deleting the inserted points in random order in the
inputs is not drawn onto the screen or or with every
mouseclick by deleting the point nearest to the center of the
window.

@<Input from keyboard or file@>=

Triangulation T(dimension, m);
d_rat_point x(dimension);
int mouse;
array<integer> L(0,2);
L[0]=100;
if (dimension == 2 && !suppress) {
  window  W;
  W.clear();
  do {
    if (read_from == KEYS) 
      cin >> x;
    else 
      file_in >> x;
    if (!(file_in.eof() || cin.eof()))
      T.insert(x);
    if (!suppress && draw_all) {
    W.clear();
    T.show(W);
    }
    if (print_simplices) T.print_all();
  } while (!(file_in.eof() || cin.eof()));
  W.clear();
  T.show(W);
  cout << "Press the right button in the drawing window to terminate,\n"
       << "or middle button to delete a random point.\n";
  cout.flush();
  while((mouse=W.read_mouse()) != 3) {
    if (mouse==2) {
     L[1]=50;
     L[2]=50;
     d_rat_point x(L,homogeneous);
     x=T.find_closest_point(x);
     T.del(x);
     W.clear();
     T.show(W);
    }
  }
}
else {

  do {
    if (read_from == KEYS)
      cin >> x;
    else
      file_in >> x;
    if (!(file_in.eof() || cin.eof()))
      T.insert(x);
    if (print_simplices) T.print_all();
  } while (!(file_in.eof() || cin.eof()));
  list<d_rat_point> points = T.points();
  points.permute();
  cout << "\n insert finished, now deleting points in random order\n\n";
  cout.flush();
  forall(x,points) 
    T.del(x);

}

cout << endl << "Searched Simplices: " << T.searched_simplices << endl;
cout << "Simplices created: " << T.created_simplices() << endl;
cout.flush();
        // only for statistical reasons

