@* Running Time Measurements.

We show some running times of our program. The equipment used for this
measures was a PC based on an Intel Pentium processor with 75MHz and 8MB
ram running Linux.

The tests were performed on a random input created by the following
program.

@(rand.c@>=
/*  The Random Vector Generator */
#include <stdlib.h>
#include <time.h>

typedef unsigned long int ulong;

int main(argc,argv)
int argc;
char **argv;
{
ulong dim;
ulong num;
ulong i,j;

if (argc != 3) {
  printf("%s: <dim> <num>\n",argv[0]);
  return 10;
}

dim = strtoul(argv[1],NULL,10);
num = strtoul(argv[2],NULL,10);

srandom(time(NULL));

printf("%ld\n%ld\n",dim,num);
for (i = 0; i < num; i++) {
  for (j = 0; j < dim; j++)
    printf("%10ld  ",random());
  printf("\n");
}
}


@
\newpage
The time used was measured using the {\sc UNIX} '{\tt time}'-command in the following
way: '{\tt time -p chull f testinput n s <Method>}', where {\tt <Method>}
was set to {\tt V}, {\tt M}, and {\tt S} respectively for the same
inputfile.
The times shown in the following figure are the '{\tt user}' time in seconds.
The '{\tt real}' and the '{\tt sys}' time depend very much on swapping, which
the system did heavily during the tests.

\input{tab.latex}

There are some things to observe. First, the {\sl
modified-visibility}-method is always slightly faster then the unchanged {\sl
visibility}-method. Next, the {\sl segment-walk}-method searches
significantly fewer simplices than the {\sl modified-visisibility}-method,
which searches slightly fewer simplices than the {\sl visibility}-method.
However this results not in a better running time for the {\sl segment-walk}-method
before some size of the triangulation is reached.


@* Useful Literature.

\begin{thebibliography}{11}
\bibitem{QHULL}
{C.\ Bradford Barber, David P.\ Dobkin, Hannu Huhdanpaa}
{``The quickhull Algorithm for Convex Hull''}
{Geometry Center Technical Report GCG53, University of Minnesota,
available via anonymous ftp from {\tt geom.umn.edu:pub/qhull.tar.Z}}

\bibitem{BMS}
{Christoph Burnikel, Kurt Mehlhorn, Stefan Schirra}
{``On Degeneracy in Geometric Computations'',}
{available from Chr. Burnikel at the Max-Planck-Institut f\"ur
Informatik, Saarbr\"ucken}

\bibitem{CMS}
{K.E. Clarkson, K. Mehlhorn, Raimund Seidel}
{``Four Results on Randomized Incremental Constructions''}
{Technical Report MPI-I-92-112, March 1992}

\bibitem{KL}
{Donald Knuth, Silvio Levy}
{``The CWEB System of Structured Documentation''}
{available via anonymous ftp from {\tt
labrea.stanford.edu:\allowbreak/pub/cweb/cweb.tar.gz}
or {\tt
ftp.th-darmstadt.de:\allowbreak/pub/programming/literate-programming/c.c++/cweb.tar.gz}}

\bibitem{KM}
Kurt Mehlhorn, "Sources and Documentation of the Data Types
{\tt d\_rat\_point} and {\tt hyperplane}",
{available from the author at the Max-Planck-Institut f\"ur
Informatik, Saarbr\"ucken}
  
\bibitem{MZ}
{Michael M\"uller, Joachim Ziegler:
``An Implementation of a Convex Hull Algorithm, Version 1.0``,
Technischer Bericht, MPI-I-94-105,
Max-Planck-Institut f\"ur Informatik, Saarbr\"ucken, 1994.}

\bibitem{leda-manual}
{Stefan N\"aher, Christian Uhrig: ``The LEDA User Manual (Version R 3.2)",
 Technischer Bericht, MPI-I-95-1-002,
Max-Planck-Institut f\"ur Informatik, Saarbr\"ucken, 1995.}

\end{thebibliography}

\newpage
\listoffigures

\end{document}
